<?php
session_start();

// Verifica se o usuário está logado e tem o perfil correto
if (!isset($_SESSION['usuario']) || strtoupper($_SESSION['usuario']['perfil']) !== 'ADMINISTRADOR') {
    header("Location: login.php");
    exit;
}

// Carrega os dados do usuário logado
$usuario = $_SESSION['usuario'];
$nome = $usuario['nome'] ?? 'Subdiretor(a)';
$foto = $usuario['foto'] ?? 'sem-foto.png';
?>


<!DOCTYPE html>
<html lang="pt">
<head>
  <meta charset="UTF-8">
  <title>Painel Subdirecção Pedagógica</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
  <link rel="stylesheet" href="adminlte/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="adminlte/dist/css/adminlte.min.css">
  <style>
    body { margin: 0; font-family: 'Segoe UI', sans-serif; background-color: #f4f6f9; }
    .sidebar { width: 260px; background: #001f3f; color: white; position: fixed; top: 0; bottom: 0; padding-top: 60px; }
    .sidebar a { display: block; color: white; padding: 15px 20px; text-decoration: none; }
    .sidebar a:hover { background: #0056b3; }
    .topbar { position: fixed; left: 260px; right: 0; top: 0; height: 60px; background: #003366; color: white; display: flex; align-items: center; justify-content: space-between; padding: 0 20px; }
    .topbar .user-info { display: flex; align-items: center; gap: 10px; }
    .topbar img { width: 40px; height: 40px; border-radius: 50%; object-fit: cover; border: 2px solid white; }
    .main-content { margin-left: 260px; margin-top: 60px; padding: 30px; }

    .charts-container {
      display: flex;
      flex-wrap: wrap;
      gap: 20px;
      margin-top: 30px;
    }

    .chart-box {
      flex: 1 1 45%;
      background: white;
      padding: 20px;
      border-radius: 10px;
      box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    }

    .chart-box h4 {
      margin-bottom: 10px;
      color: #003366;
      font-weight: bold;
      text-align: center;
    }

    canvas {
      width: 100% !important;
      height: 300px !important;
    }
  </style>
</head>
<body>

<div class="sidebar">
  <!-- Sidebar mantida igual -->

  
  <a href="estatistica.php"><i class="fas fa-upload"></i>Estatística</a>
 
  <a href="#"><i class="fas fa-chalkboard-teacher"></i> Desempenho do Professor</a>
  <a href="#"><i class="fas fa-comments"></i> Ver Sugestões</a>
  <a href="#"><i class="fas fa-reply"></i> Responder Sugestões</a>
  <a href="consultar_horario.php"><i class="fas fa-upload"></i> Gerador de horários</a>
  <a href="documentos_recebidos.php">📂 Documentos Recebidos</a>
  <a href="enviar_documento.php"><i class="fas fa-upload"></i> Enviar Documento</a>
  <a href="atribuir_disciplina.php"><i class="fas fa-upload"></i> Atribuir Disciplina</a>
  <a href="cadastrar_disciplina_anterior1.php"><i class="fas fa-upload"></i> Cadastrar Disciplina</a>
<a href="cadastrar_usuario1.php"><i class="fas fa-upload"></i> Cadastrar Usuário</a>
   <a href="definir_tempos_disciplina.php"><i class="fas fa-upload"></i>Definir tempos semanais</a>
   <a href="fechar_trimestre_geral.php"><i class="fas fa-upload"></i>Fechar Trimestre</a>


  <a href="cadastrar_nota.php"><i class="fas fa-upload"></i> Lançar Nota</a>
 <a href="painel_certificados.php"><i class="fas fa-upload"></i> Certificado</a>

  <a href="ativar_prazos.php"><i class="fas fa-upload"></i> Activar Prazos de Lançamento</a>
  <a href="selecionar_turma.php"><i class="fas fa-upload"></i> Pauta Final</a>
  <a href="login.php"><i class="fas fa-sign-out-alt"></i> Sair</a>
</div>

<div class="topbar">
  <div class="topbar-left">
    <strong>SISMAG</strong> | <span>Bem-vindo: <strong><?= htmlspecialchars($nome) ?></strong></span>
  </div>
  <div class="user-info">
    <form action="atualizar_foto.php" method="post" enctype="multipart/form-data" id="fotoUploadForm">
      <label for="fotoUpload">
        <img src="fotos/<?= htmlspecialchars($foto) ?>" alt="Foto" id="userPhoto">
      </label>
      <input type="file" name="foto" id="fotoUpload" style="display:none;" onchange="this.form.submit();">
    </form>
    <span><?= htmlspecialchars($nome) ?></span>
  </div>
</div>

<div class="main-content">
  <h2>Bem-vindo(a), <?= htmlspecialchars($nome) ?>!</h2>
  <p>Selecione uma funcionalidade na barra lateral.</p>

  <div style="margin-top: 30px; display: flex; gap: 20px;">
    <a href="gerar_horario.php">
      <button style="padding: 12px 20px; font-size: 16px; background-color: #003366; color: white; border: none; border-radius: 5px; cursor: pointer;">
        <i class="fas fa-clock"></i> Gerar Horário
      </button>
    </a>
    <a href="definir_tempos_disciplina.php">
      <button style="padding: 12px 20px; font-size: 16px; background-color: #0069d9; color: white; border: none; border-radius: 5px; cursor: pointer;">
        <i class="fas fa-list-ol"></i> Definir Tempos Semanais
      </button>
    </a>
  </div>

  <div class="charts-container" style="margin-top: 40px;">
    <!-- Gráfico de Pizza -->
    <div class="chart-box">
      <h4>Evolução de Notas dos Professores</h4>
      <canvas id="graficoPizzaProfessores"></canvas>
    </div>

    <!-- Gráfico de Colunas -->
    <div class="chart-box">
      <h4>Evolução de Notas dos Alunos</h4>
      <canvas id="graficoColunaAlunos"></canvas>
    </div>
  </div>
</div>

<script>
  // Gráfico de Pizza (Professores)
  new Chart(document.getElementById('graficoPizzaProfessores'), {
    type: 'pie',
    data: {
      labels: ['Excelente', 'Bom', 'Satisfatório', 'Insuficiente'],
      datasets: [{
        label: 'Desempenho',
        data: [30, 40, 20, 10],
        backgroundColor: ['#28a745', '#007bff', '#ffc107', '#dc3545']
      }]
    },
    options: {
      responsive: true,
      plugins: {
        legend: { position: 'bottom' }
      }
    }
  });

  // Gráfico de Colunas (Alunos)
  new Chart(document.getElementById('graficoColunaAlunos'), {
    type: 'bar',
    data: {
      labels: ['1º Tri', '2º Tri', '3º Tri'],
      datasets: [{
        label: 'Notas Média',
        data: [10.5, 12.0, 13.2],
        backgroundColor: '#003366'
      }]
    },
    options: {
      responsive: true,
      scales: {
        y: {
          beginAtZero: true,
          max: 20
        }
      },
      plugins: {
        legend: { display: false }
      }
    }
  });
</script>
</body>
</html>
